/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.iosrobovm;

import com.badlogic.gdx.backends.iosrobovm.IOSApplication;
import com.badlogic.gdx.backends.iosrobovm.IOSGraphics;
import com.badlogic.gdx.backends.iosrobovm.IOSScreenBounds;
import com.badlogic.gdx.graphics.glutils.HdpiMode;
import org.robovm.apple.foundation.NSSet;
import org.robovm.apple.glkit.GLKViewController;
import org.robovm.apple.uikit.UIDevice;
import org.robovm.apple.uikit.UIInterfaceOrientation;
import org.robovm.apple.uikit.UIInterfaceOrientationMask;
import org.robovm.apple.uikit.UIPress;
import org.robovm.apple.uikit.UIPressesEvent;
import org.robovm.apple.uikit.UIRectEdge;
import org.robovm.apple.uikit.UIScreen;
import org.robovm.apple.uikit.UIUserInterfaceIdiom;

public class IOSUIViewController
extends GLKViewController {
    final IOSApplication app;
    final IOSGraphics graphics;

    protected IOSUIViewController(IOSApplication app, IOSGraphics graphics) {
        this.app = app;
        this.graphics = graphics;
    }

    public void viewWillAppear(boolean animated) {
        super.viewWillAppear(animated);
        this.setPaused(false);
    }

    public void viewDidAppear(boolean animated) {
        super.viewDidAppear(animated);
        this.getView().setContentScaleFactor(UIScreen.getMainScreen().getNativeScale());
        if (this.app.viewControllerListener != null) {
            this.app.viewControllerListener.viewDidAppear(animated);
        }
    }

    public UIInterfaceOrientationMask getSupportedInterfaceOrientations() {
        long mask = 0L;
        if (this.app.config.orientationLandscape) {
            mask |= 1L << (int)UIInterfaceOrientation.LandscapeLeft.value() | 1L << (int)UIInterfaceOrientation.LandscapeRight.value();
        }
        if (this.app.config.orientationPortrait) {
            mask |= 1L << (int)UIInterfaceOrientation.Portrait.value();
            if (UIDevice.getCurrentDevice().getUserInterfaceIdiom() == UIUserInterfaceIdiom.Pad) {
                mask |= 1L << (int)UIInterfaceOrientation.PortraitUpsideDown.value();
            }
        }
        return new UIInterfaceOrientationMask(mask);
    }

    public boolean shouldAutorotate() {
        return true;
    }

    public UIRectEdge getPreferredScreenEdgesDeferringSystemGestures() {
        return this.app.config.screenEdgesDeferringSystemGestures;
    }

    public void viewDidLayoutSubviews() {
        IOSScreenBounds newBounds;
        super.viewDidLayoutSubviews();
        IOSScreenBounds oldBounds = this.graphics.screenBounds;
        this.graphics.screenBounds = newBounds = this.app.computeBounds();
        if (newBounds.width != oldBounds.width || newBounds.height != oldBounds.height) {
            this.graphics.makeCurrent();
            this.graphics.updateSafeInsets();
            this.graphics.gl20.glViewport(0, 0, newBounds.backBufferWidth, newBounds.backBufferHeight);
            if (this.graphics.config.hdpiMode == HdpiMode.Pixels) {
                this.app.listener.resize(newBounds.backBufferWidth, newBounds.backBufferHeight);
            } else {
                this.app.listener.resize(newBounds.width, newBounds.height);
            }
        }
    }

    public boolean prefersStatusBarHidden() {
        return !this.app.config.statusBarVisible;
    }

    public boolean prefersHomeIndicatorAutoHidden() {
        return this.app.config.hideHomeIndicator;
    }

    public void pressesBegan(NSSet<UIPress> presses, UIPressesEvent event) {
        if (presses == null || presses.isEmpty() || !this.app.input.onKey(((UIPress)presses.getValues().first()).getKey(), true)) {
            super.pressesBegan(presses, event);
        }
    }

    public void pressesEnded(NSSet<UIPress> presses, UIPressesEvent event) {
        if (presses == null || presses.isEmpty() || !this.app.input.onKey(((UIPress)presses.getValues().first()).getKey(), false)) {
            super.pressesEnded(presses, event);
        }
    }
}

