/*
 * Decompiled with CFR 0.152.
 */
package jdk.xml.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;

class SecuritySupport {
    static final Properties cacheProps = new Properties();
    static volatile boolean firstTime = true;

    private SecuritySupport() {
    }

    public static String getSystemProperty(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(string);
            }
        });
    }

    public static <T> T getJAXPSystemProperty(Class<T> clazz, String string, String string2) {
        String string3 = SecuritySupport.getJAXPSystemProperty(string);
        if (string3 == null) {
            string3 = string2;
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return clazz.cast(Integer.parseInt(string3));
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return clazz.cast(Boolean.parseBoolean(string3));
        }
        return clazz.cast(string3);
    }

    public static String getJAXPSystemProperty(String string) {
        String string2 = SecuritySupport.getSystemProperty(string);
        if (string2 == null) {
            string2 = SecuritySupport.readJAXPProperty(string);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readJAXPProperty(String string) {
        String string2 = null;
        InputStream inputStream = null;
        try {
            if (firstTime) {
                Properties properties = cacheProps;
                synchronized (properties) {
                    if (firstTime) {
                        String string3 = SecuritySupport.getSystemProperty("java.home") + File.separator + "lib" + File.separator + "jaxp.properties";
                        File file = new File(string3);
                        if (SecuritySupport.getFileExists(file)) {
                            inputStream = SecuritySupport.getFileInputStream(file);
                            cacheProps.load(inputStream);
                        }
                        firstTime = false;
                    }
                }
            }
            string2 = cacheProps.getProperty(string);
        }
        catch (IOException iOException) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string2;
    }

    static boolean getFileExists(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.exists() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    static FileInputStream getFileInputStream(final File file) throws FileNotFoundException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws Exception {
                    return new FileInputStream(file);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (FileNotFoundException)privilegedActionException.getException();
        }
    }
}

