/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.iosrobovm;

import com.badlogic.gdx.graphics.GL20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class IOSGLES20
implements GL20 {
    final boolean shouldConvert16bit;
    public static int x;
    public static int y;
    public static int width;
    public static int height;

    public IOSGLES20() {
        this.shouldConvert16bit = false;
        IOSGLES20.init();
    }

    private static native void init();

    @Override
    public native void glActiveTexture(int var1);

    @Override
    public native void glAttachShader(int var1, int var2);

    @Override
    public native void glBindAttribLocation(int var1, int var2, String var3);

    @Override
    public native void glBindBuffer(int var1, int var2);

    @Override
    public native void glBindFramebuffer(int var1, int var2);

    @Override
    public native void glBindRenderbuffer(int var1, int var2);

    @Override
    public native void glBindTexture(int var1, int var2);

    @Override
    public native void glBlendColor(float var1, float var2, float var3, float var4);

    @Override
    public native void glBlendEquation(int var1);

    @Override
    public native void glBlendEquationSeparate(int var1, int var2);

    @Override
    public native void glBlendFunc(int var1, int var2);

    @Override
    public native void glBlendFuncSeparate(int var1, int var2, int var3, int var4);

    @Override
    public native void glBufferData(int var1, int var2, Buffer var3, int var4);

    @Override
    public native void glBufferSubData(int var1, int var2, int var3, Buffer var4);

    @Override
    public native int glCheckFramebufferStatus(int var1);

    @Override
    public native void glClear(int var1);

    @Override
    public native void glClearColor(float var1, float var2, float var3, float var4);

    @Override
    public native void glClearDepthf(float var1);

    @Override
    public native void glClearStencil(int var1);

    @Override
    public native void glColorMask(boolean var1, boolean var2, boolean var3, boolean var4);

    @Override
    public native void glCompileShader(int var1);

    @Override
    public native void glCompressedTexImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, Buffer var8);

    @Override
    public native void glCompressedTexSubImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, Buffer var9);

    @Override
    public native void glCopyTexImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    @Override
    public native void glCopyTexSubImage2D(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    @Override
    public native int glCreateProgram();

    @Override
    public native int glCreateShader(int var1);

    @Override
    public native void glCullFace(int var1);

    @Override
    public native void glDeleteBuffers(int var1, IntBuffer var2);

    @Override
    public native void glDeleteBuffer(int var1);

    @Override
    public native void glDeleteFramebuffers(int var1, IntBuffer var2);

    @Override
    public native void glDeleteFramebuffer(int var1);

    @Override
    public native void glDeleteProgram(int var1);

    @Override
    public native void glDeleteRenderbuffers(int var1, IntBuffer var2);

    @Override
    public native void glDeleteRenderbuffer(int var1);

    @Override
    public native void glDeleteShader(int var1);

    @Override
    public native void glDeleteTextures(int var1, IntBuffer var2);

    @Override
    public native void glDeleteTexture(int var1);

    @Override
    public native void glDepthFunc(int var1);

    @Override
    public native void glDepthMask(boolean var1);

    @Override
    public native void glDepthRangef(float var1, float var2);

    @Override
    public native void glDetachShader(int var1, int var2);

    @Override
    public native void glDisable(int var1);

    @Override
    public native void glDisableVertexAttribArray(int var1);

    @Override
    public native void glDrawArrays(int var1, int var2, int var3);

    @Override
    public native void glDrawElements(int var1, int var2, int var3, Buffer var4);

    @Override
    public native void glDrawElements(int var1, int var2, int var3, int var4);

    @Override
    public native void glEnable(int var1);

    @Override
    public native void glEnableVertexAttribArray(int var1);

    @Override
    public native void glFinish();

    @Override
    public native void glFlush();

    @Override
    public native void glFramebufferRenderbuffer(int var1, int var2, int var3, int var4);

    @Override
    public native void glFramebufferTexture2D(int var1, int var2, int var3, int var4, int var5);

    @Override
    public native void glFrontFace(int var1);

    @Override
    public native void glGenBuffers(int var1, IntBuffer var2);

    @Override
    public native int glGenBuffer();

    @Override
    public native void glGenerateMipmap(int var1);

    @Override
    public native void glGenFramebuffers(int var1, IntBuffer var2);

    @Override
    public native int glGenFramebuffer();

    @Override
    public native void glGenRenderbuffers(int var1, IntBuffer var2);

    @Override
    public native int glGenRenderbuffer();

    @Override
    public native void glGenTextures(int var1, IntBuffer var2);

    @Override
    public native int glGenTexture();

    @Override
    public native String glGetActiveAttrib(int var1, int var2, IntBuffer var3, IntBuffer var4);

    @Override
    public native String glGetActiveUniform(int var1, int var2, IntBuffer var3, IntBuffer var4);

    @Override
    public native void glGetAttachedShaders(int var1, int var2, Buffer var3, IntBuffer var4);

    @Override
    public native int glGetAttribLocation(int var1, String var2);

    @Override
    public native void glGetBooleanv(int var1, Buffer var2);

    @Override
    public native void glGetBufferParameteriv(int var1, int var2, IntBuffer var3);

    @Override
    public native int glGetError();

    @Override
    public native void glGetFloatv(int var1, FloatBuffer var2);

    @Override
    public native void glGetFramebufferAttachmentParameteriv(int var1, int var2, int var3, IntBuffer var4);

    @Override
    public native void glGetIntegerv(int var1, IntBuffer var2);

    @Override
    public native void glGetProgramiv(int var1, int var2, IntBuffer var3);

    @Override
    public native String glGetProgramInfoLog(int var1);

    @Override
    public native void glGetRenderbufferParameteriv(int var1, int var2, IntBuffer var3);

    @Override
    public native void glGetShaderiv(int var1, int var2, IntBuffer var3);

    @Override
    public native String glGetShaderInfoLog(int var1);

    @Override
    public native void glGetShaderPrecisionFormat(int var1, int var2, IntBuffer var3, IntBuffer var4);

    public native void glGetShaderSource(int var1, int var2, Buffer var3, String var4);

    @Override
    public native String glGetString(int var1);

    @Override
    public native void glGetTexParameterfv(int var1, int var2, FloatBuffer var3);

    @Override
    public native void glGetTexParameteriv(int var1, int var2, IntBuffer var3);

    @Override
    public native void glGetUniformfv(int var1, int var2, FloatBuffer var3);

    @Override
    public native void glGetUniformiv(int var1, int var2, IntBuffer var3);

    @Override
    public native int glGetUniformLocation(int var1, String var2);

    @Override
    public native void glGetVertexAttribfv(int var1, int var2, FloatBuffer var3);

    @Override
    public native void glGetVertexAttribiv(int var1, int var2, IntBuffer var3);

    @Override
    public native void glGetVertexAttribPointerv(int var1, int var2, Buffer var3);

    @Override
    public native void glHint(int var1, int var2);

    @Override
    public native boolean glIsBuffer(int var1);

    @Override
    public native boolean glIsEnabled(int var1);

    @Override
    public native boolean glIsFramebuffer(int var1);

    @Override
    public native boolean glIsProgram(int var1);

    @Override
    public native boolean glIsRenderbuffer(int var1);

    @Override
    public native boolean glIsShader(int var1);

    @Override
    public native boolean glIsTexture(int var1);

    @Override
    public native void glLineWidth(float var1);

    @Override
    public native void glLinkProgram(int var1);

    @Override
    public native void glPixelStorei(int var1, int var2);

    @Override
    public native void glPolygonOffset(float var1, float var2);

    @Override
    public native void glReadPixels(int var1, int var2, int var3, int var4, int var5, int var6, Buffer var7);

    @Override
    public native void glReleaseShaderCompiler();

    @Override
    public native void glRenderbufferStorage(int var1, int var2, int var3, int var4);

    @Override
    public native void glSampleCoverage(float var1, boolean var2);

    @Override
    public native void glScissor(int var1, int var2, int var3, int var4);

    @Override
    public native void glShaderBinary(int var1, IntBuffer var2, int var3, Buffer var4, int var5);

    @Override
    public native void glShaderSource(int var1, String var2);

    @Override
    public native void glStencilFunc(int var1, int var2, int var3);

    @Override
    public native void glStencilFuncSeparate(int var1, int var2, int var3, int var4);

    @Override
    public native void glStencilMask(int var1);

    @Override
    public native void glStencilMaskSeparate(int var1, int var2);

    @Override
    public native void glStencilOp(int var1, int var2, int var3);

    @Override
    public native void glStencilOpSeparate(int var1, int var2, int var3, int var4);

    static Buffer convert16bitBufferToRGBA8888(Buffer buffer, int type) {
        ByteBuffer byteBuffer = (ByteBuffer)buffer;
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer converted = ByteBuffer.allocateDirect(byteBuffer.limit() * 2);
        while (buffer.remaining() != 0) {
            int rgba8888;
            byte a;
            byte b;
            byte g;
            byte r;
            short color = byteBuffer.getShort();
            if (type == 32819) {
                r = (byte)(color >> 12 & 0xF);
                g = (byte)(color >> 8 & 0xF);
                b = (byte)(color >> 4 & 0xF);
                a = (byte)(color & 0xF);
                rgba8888 = (r << 4 | r) << 24 | (g << 4 | g) << 16 | (b << 4 | b) << 8 | (a << 4 | a);
            } else if (type == 33635) {
                r = (byte)(color >> 11 & 0x1F);
                g = (byte)(color >> 5 & 0x3F);
                b = (byte)(color & 0x1F);
                rgba8888 = (r << 3 | r >> 2) << 24 | (g << 2 | g >> 4) << 16 | (b << 3 | b >> 2) << 8 | 0xFF;
            } else {
                r = (byte)(color >> 11 & 0x1F);
                g = (byte)(color >> 6 & 0x1F);
                b = (byte)(color >> 5 & 0x1F);
                a = (byte)(color & 1);
                rgba8888 = (r << 3 | r >> 2) << 24 | (g << 3 | g >> 2) << 16 | (b << 3 | b >> 2) << 8 | a * 255;
            }
            converted.putInt(rgba8888);
        }
        converted.position(0);
        return converted;
    }

    @Override
    public void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, Buffer pixels) {
        if (!this.shouldConvert16bit) {
            this.glTexImage2DJNI(target, level, internalformat, width, height, border, format, type, pixels);
            return;
        }
        if (type != 33635 && type != 32820 && type != 32819) {
            this.glTexImage2DJNI(target, level, internalformat, width, height, border, format, type, pixels);
            return;
        }
        Buffer converted = IOSGLES20.convert16bitBufferToRGBA8888(pixels, type);
        this.glTexImage2DJNI(target, level, 6408, width, height, border, 6408, 5121, converted);
    }

    public native void glTexImage2DJNI(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, Buffer var9);

    @Override
    public native void glTexParameterf(int var1, int var2, float var3);

    @Override
    public native void glTexParameterfv(int var1, int var2, FloatBuffer var3);

    @Override
    public native void glTexParameteri(int var1, int var2, int var3);

    @Override
    public native void glTexParameteriv(int var1, int var2, IntBuffer var3);

    @Override
    public void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, Buffer pixels) {
        if (!this.shouldConvert16bit) {
            this.glTexSubImage2DJNI(target, level, xoffset, yoffset, width, height, format, type, pixels);
            return;
        }
        if (type != 33635 && type != 32820 && type != 32819) {
            this.glTexSubImage2DJNI(target, level, xoffset, yoffset, width, height, format, type, pixels);
            return;
        }
        Buffer converted = IOSGLES20.convert16bitBufferToRGBA8888(pixels, type);
        this.glTexSubImage2DJNI(target, level, xoffset, yoffset, width, height, 6408, 5121, converted);
    }

    public native void glTexSubImage2DJNI(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, Buffer var9);

    @Override
    public native void glUniform1f(int var1, float var2);

    @Override
    public native void glUniform1fv(int var1, int var2, FloatBuffer var3);

    @Override
    public native void glUniform1fv(int var1, int var2, float[] var3, int var4);

    @Override
    public native void glUniform1i(int var1, int var2);

    @Override
    public native void glUniform1iv(int var1, int var2, IntBuffer var3);

    @Override
    public native void glUniform1iv(int var1, int var2, int[] var3, int var4);

    @Override
    public native void glUniform2f(int var1, float var2, float var3);

    @Override
    public native void glUniform2fv(int var1, int var2, FloatBuffer var3);

    @Override
    public native void glUniform2fv(int var1, int var2, float[] var3, int var4);

    @Override
    public native void glUniform2i(int var1, int var2, int var3);

    @Override
    public native void glUniform2iv(int var1, int var2, IntBuffer var3);

    @Override
    public native void glUniform2iv(int var1, int var2, int[] var3, int var4);

    @Override
    public native void glUniform3f(int var1, float var2, float var3, float var4);

    @Override
    public native void glUniform3fv(int var1, int var2, FloatBuffer var3);

    @Override
    public native void glUniform3fv(int var1, int var2, float[] var3, int var4);

    @Override
    public native void glUniform3i(int var1, int var2, int var3, int var4);

    @Override
    public native void glUniform3iv(int var1, int var2, IntBuffer var3);

    @Override
    public native void glUniform3iv(int var1, int var2, int[] var3, int var4);

    @Override
    public native void glUniform4f(int var1, float var2, float var3, float var4, float var5);

    @Override
    public native void glUniform4fv(int var1, int var2, FloatBuffer var3);

    @Override
    public native void glUniform4fv(int var1, int var2, float[] var3, int var4);

    @Override
    public native void glUniform4i(int var1, int var2, int var3, int var4, int var5);

    @Override
    public native void glUniform4iv(int var1, int var2, IntBuffer var3);

    @Override
    public native void glUniform4iv(int var1, int var2, int[] var3, int var4);

    @Override
    public native void glUniformMatrix2fv(int var1, int var2, boolean var3, FloatBuffer var4);

    @Override
    public native void glUniformMatrix2fv(int var1, int var2, boolean var3, float[] var4, int var5);

    @Override
    public native void glUniformMatrix3fv(int var1, int var2, boolean var3, FloatBuffer var4);

    @Override
    public native void glUniformMatrix3fv(int var1, int var2, boolean var3, float[] var4, int var5);

    @Override
    public native void glUniformMatrix4fv(int var1, int var2, boolean var3, FloatBuffer var4);

    @Override
    public native void glUniformMatrix4fv(int var1, int var2, boolean var3, float[] var4, int var5);

    @Override
    public native void glUseProgram(int var1);

    @Override
    public native void glValidateProgram(int var1);

    @Override
    public native void glVertexAttrib1f(int var1, float var2);

    @Override
    public native void glVertexAttrib1fv(int var1, FloatBuffer var2);

    @Override
    public native void glVertexAttrib2f(int var1, float var2, float var3);

    @Override
    public native void glVertexAttrib2fv(int var1, FloatBuffer var2);

    @Override
    public native void glVertexAttrib3f(int var1, float var2, float var3, float var4);

    @Override
    public native void glVertexAttrib3fv(int var1, FloatBuffer var2);

    @Override
    public native void glVertexAttrib4f(int var1, float var2, float var3, float var4, float var5);

    @Override
    public native void glVertexAttrib4fv(int var1, FloatBuffer var2);

    @Override
    public native void glVertexAttribPointer(int var1, int var2, int var3, boolean var4, int var5, Buffer var6);

    @Override
    public native void glVertexAttribPointer(int var1, int var2, int var3, boolean var4, int var5, int var6);

    @Override
    public void glViewport(int x, int y, int width, int height) {
        IOSGLES20.x = x;
        IOSGLES20.y = y;
        IOSGLES20.width = width;
        IOSGLES20.height = height;
        this.glViewportJni(x, y, width, height);
    }

    public native void glViewportJni(int var1, int var2, int var3, int var4);
}

