/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.controllers;

import com.badlogic.gdx.controllers.AbstractController;
import com.badlogic.gdx.controllers.ControllerMapping;
import com.badlogic.gdx.controllers.ControllerPowerLevel;
import com.badlogic.gdx.controllers.ICadeMapping;

public class ICadeController
extends AbstractController {
    protected static final String KEYS_AXIS = "aqdcwexz";
    protected static final String KEYS_BUTTONS = "hrufytjnimkplvog";
    public static final String KEYS_TO_HANDLE = "hrufytjnimkplvogaqdcwexz";
    private final boolean[] buttonPressed = new boolean["hrufytjnimkplvogaqdcwexz".length() / 2];

    @Override
    public String getUniqueId() {
        return "icade";
    }

    @Override
    public int getMinButtonIndex() {
        return 0;
    }

    @Override
    public int getMaxButtonIndex() {
        return KEYS_BUTTONS.length() / 2 - 1;
    }

    @Override
    public int getAxisCount() {
        return KEYS_AXIS.length() / 4;
    }

    @Override
    public boolean getButton(int i) {
        if (i <= this.getMaxButtonIndex()) {
            return this.buttonPressed[i];
        }
        return false;
    }

    @Override
    public float getAxis(int i) {
        if (i < this.getAxisCount()) {
            int offset = this.getMaxButtonIndex() + 1 + i * 2;
            if (this.buttonPressed[offset] && !this.buttonPressed[offset + 1]) {
                return -1.0f;
            }
            if (!this.buttonPressed[offset] && this.buttonPressed[offset + 1]) {
                return 1.0f;
            }
            return 0.0f;
        }
        return 0.0f;
    }

    @Override
    public ControllerMapping getMapping() {
        return ICadeMapping.getInstance();
    }

    @Override
    public ControllerPowerLevel getPowerLevel() {
        return ControllerPowerLevel.POWER_UNKNOWN;
    }

    @Override
    public String getName() {
        return "iCade device";
    }

    public void handleKeyPressed(String keyPressed) {
        int index = KEYS_TO_HANDLE.indexOf(keyPressed);
        if (index >= 0) {
            boolean buttonDown;
            int buttonNum = index / 2;
            boolean bl = buttonDown = index % 2 == 0;
            if (this.buttonPressed[buttonNum] != buttonDown) {
                this.buttonPressed[buttonNum] = buttonDown;
                if (buttonNum <= this.getMaxButtonIndex()) {
                    if (buttonDown) {
                        this.notifyListenersButtonDown(buttonNum);
                    } else {
                        this.notifyListenersButtonUp(buttonNum);
                    }
                } else {
                    int axisNum = (buttonNum - this.getMaxButtonIndex() - 1) / 2;
                    this.notifyListenersAxisMoved(axisNum, this.getAxis(axisNum));
                }
            }
        }
    }
}

